/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.std;

import com.quantumdata.std.IRemoteConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public class SocketConnection
implements IRemoteConnection {
    public static final int CMD_PORT_NUM = 6500;
    public static final int LOG_PORT_NUM = 40000;
    private Socket m_socket = new Socket();
    private String m_host;
    private int m_portNumber;
    private boolean m_isConnected;
    private String m_errorMessage;

    public SocketConnection(String hostName) {
        this.m_host = hostName;
        this.m_isConnected = false;
        this.m_portNumber = 6500;
        this.m_errorMessage = "";
    }

    public SocketConnection(String hostName, int portNumber) {
        this.m_host = hostName;
        this.m_isConnected = false;
        this.m_portNumber = portNumber;
        this.m_errorMessage = "";
    }

    public String getName() {
        return this.m_host;
    }

    public boolean isEchoing() {
        return false;
    }

    public String getEndOfResponse() {
        return "\r\n;";
    }

    public String getEndOfPrompt() {
        return "";
    }

    public void connect() throws Exception {
        if (this.m_isConnected) {
            return;
        }
        InetSocketAddress addr = new InetSocketAddress(this.m_host, this.m_portNumber);
        if (addr.isUnresolved()) {
            this.m_errorMessage = "Unable to resolve address " + this.m_host + ":" + this.m_portNumber;
            throw new Exception(this.m_errorMessage);
        }
        this.m_socket = new Socket();
        try {
            this.m_socket.connect(addr);
        }
        catch (Exception ex) {
            this.m_errorMessage = ex.getMessage();
            throw ex;
        }
        if (!this.m_socket.isConnected()) {
            this.m_errorMessage = "Unable to connect";
            throw new Exception(this.m_errorMessage);
        }
        this.m_isConnected = true;
    }

    public void disconnect() throws Exception {
        this.m_isConnected = false;
        this.m_socket.close();
    }

    public boolean isConnected() {
        return this.m_isConnected;
    }

    public OutputStream getOutputStream() throws IOException {
        if (!this.m_isConnected) {
            return null;
        }
        return this.m_socket.getOutputStream();
    }

    public InputStream getInputStream() throws IOException {
        if (!this.m_isConnected) {
            return null;
        }
        return this.m_socket.getInputStream();
    }

    public String getHostName() {
        return this.m_host;
    }

    public void setHostName(String hostIp) {
        if (this.m_isConnected) {
            try {
                this.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_host = hostIp;
    }

    public IRemoteConnection getAlternateChannel() {
        return new SocketConnection(this.m_host, this.m_portNumber);
    }

    public String getErrorMessage() {
        return this.m_errorMessage;
    }
}

